from src.present_act.gates import ThetaLadder, KappaLadder, StructuralGates, CRA
from src.present_act.lints import Lints
from src.present_act.engine import PresentActEngine, RunManifest
from src.present_act.scenes import make_optics_scene, make_optics_roi

def test_rng_only_at_ties():
    scene = make_optics_scene(96, w=5)
    screen = make_optics_roi(scene)

    # Two sources same x (center), different rows → same endpoint (tie).
    cx = scene.W // 2
    y1 = scene.H // 4
    y2 = y1 + 6

    # Θ deep enough for BOTH sources (use max distance to midline).
    roi_mid = (scene.roi_bbox[1] + scene.roi_bbox[3]) // 2
    depth = max(abs(y1 - roi_mid), abs(y2 - roi_mid)) + 2
    theta = ThetaLadder([depth, depth + 1, depth + 2])
    kappa = KappaLadder([0, 1, 2])
    man = RunManifest(theta, kappa, StructuralGates(), CRA(True), Lints(), seed=101)
    eng = PresentActEngine(scene, man)

    # Tie case → RNG must fire
    cands = eng.propose_candidates([(cx, y1), (cx, y2)], screen)
    _, res1 = eng.accept(cands)
    assert res1.tie_count > 1 and res1.rng_used, f"Expected tie+RNG; got {res1}"

    # Break symmetry (shift one x) → no tie → RNG must NOT fire
    cands2 = eng.propose_candidates([(cx + 1, y2), (cx, y1)], screen)
    _, res2 = eng.accept(cands2)
    assert not res2.rng_used, f"Expected no RNG after breaking symmetry; got {res2}"
